#Cuadro IX.10
#Contrastes de homogeneidad no paramtricos para k muestras dependientes. Test de Friedman.

##############################################
#Seccin modificable por el usuario
##############################################

#Lectura de datos.
datos<-read.csv2("Cuadro IX.10.V.csv",header=TRUE,encoding="latin1")

#Seleccin de los grupos de la variable dependiente. Deben ser ms de dos y hasta un mximo de 20.
varInteres<-c("Inicio","Mes1","Mes2","Mes3")

#Bloques
varBloque<-c("Individuo")

#Archivo de salida.
ArchivodeSalida<-"Salida Cuadro IX.10.txt"

###############################################
#Seccin que realiza el procedimiento
###############################################

#Paquetes
require(stats)

##Organizacin de los datos.
datos1<-na.omit(datos)
valores<-unlist(datos1[,varInteres])
bloque<-unlist(datos1[,varBloque])
bloquetot<-rep(bloque,length(varInteres))
variables<-unlist(varInteres)
cont<-unlist(datos1[,1])
variablestot<-rep(variables,each=length(cont),1)
datos1<-data.frame(valores,bloquetot,variablestot)

#Test de Friedman.
Friedman<-friedman.test(datos1$valores,datos1$variablestot,datos1$bloquetot)

###############################################
#Seccin que muestra los resultados
###############################################

Resultados<-list(Friedman)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 sink()
}